 ; Ŀ
 ;   Hoss - make a drawing of all blocks in a certian directory.           
 ;   Put them on regular x and y spacing, scale them up or down as         
 ;   needed, optionally mark insertions and attributes.                    
 ;   Copyright 1994, 2001, 2004 by Rocket Software Ltd.                    
 ;   Computers are better at generating data than making it accessible.    
 ; 

 ; Ŀ
 ;   Subroutine Atprmp - search a block definition for attribute prompts.  
 ;   Returns a list of all prompts.                                        
 ;   Hang on - we don't want preset attibutes - they aren't prompted for.  
 ;   Maybe should be inserting the block with attreq off and then          
 ;   stepping through and installing the text strings...do we really want  
 ;   to use prompts, or should it be attdef names?                         
 ;   Returns a list of attribute tags:                                     
 ;   Attribute flags: (70 . n), n is bit coded: 1 = Invisible              
 ;                                              2 = Constant               
 ;                                              4 = Verify                 
 ;                                              8 = Preset                 
 ;   So: Invisible attributes are prompted for, Constant and Preset        
 ;   aren't, Verify are twice.                                             
 ;   So if 2 or 8 then don't include in the list, if 4 include twice.      
 ;   What if find say (70 . 12)?  Fix the program so it won't crash and    
 ;   don't try to deal with weird eventualities.                           
 ;   Later: Ddattdef doesn't allow this, but attdef does.  On insertion    
 ;   the Constant bit seems to take precedence.                            
 ; 
 (DEFUN ATPRMP (new / blok namm entt tagg sev taglst)
  (setq blok (tblsearch "block" new))    ; get head entity
  (setq namm (cdr (assoc -2 blok)))      ; first ename after head
  (while (and namm (null isdef))         ; while there is an entity
         (setq entt (entget namm))       ; the whole thing
         (if (= (cdr (assoc 0 entt)) "ATTDEF")
             (progn
                  (setq tagg (cdr (assoc 2 entt)))
                  (setq sev (cdr (assoc 70 entt)))
 ; Ŀ
 ;   Decide whether to add the attribute tag to the list.                  
 ; 
                  (cond ((= 0 sev)                  ; no flags set
                         (setq taglst (append taglst (list tagg))))
                        ((or (= 2 (logand 2 sev))   ; constant
                             (= 8 (logand 8 sev)))) ; or Preset
                        ((= 4 (logand 4 sev))       ; verify
                         (setq taglst (append taglst (list tagg tagg))))
                        ((= 1 (logand 1 sev))       ; invisible
                         (setq taglst (append taglst (list tagg)))))))
         (setq namm (entnext namm)))      ; next subentity ename
 taglst)
 ; Ŀ
 ;   Atprmp end.                                                           
 ; 

 ; Ŀ
 ;   Blosc - fit and position a block within a box.                        
 ;   Arguments: Cent, the box centre point.                                
 ;              Desx, the box width.                                       
 ;              Desy, the box height.                                      
 ;              Enam, the entity name of the block.                        
 ;   Calls Puss to find the size of the block.                             
 ;   Returns nothing.                                                      
 ; 
 (DEFUN BLOSC (cent desx desy enam / mxlst sub gnulst widf hite blcen scalfc)
  (setq mxlst (puss enam))
 ; Ŀ
 ;   Empty blocks (or all atts, etc.) return (nil nil nil nil).            
 ;   So make sure there are no ()s in the list.                            
 ; 
  (while (setq sub (car mxlst))
         (setq mxlst (cdr mxlst))
         (if (null sub) (setq sub 0))
         (setq gnulst (append gnulst (list sub))))
  (setq mxlst gnulst)
  (if (null mxlst)
      (progn
           (setq mxlst '(0 0 0 0))
           (setq bnam (cdr (assoc 2 (entget enam))))
           (prompt (strcat "Bad scale data in block " bnam))))
 ; Ŀ
 ;   Get a width and a height, make sure that neither one is zero.         
 ; 
  (setq widf (- (car mxlst) (cadr mxlst)))
  (if (= widf 0) (setq widf 1))
  (setq hite (- (caddr mxlst) (cadddr mxlst)))
  (if (= hite 0) (setq hite 1)) ; i.e. a text string containing only a dash
 ; Ŀ
 ;   Get the block centrepoint.                                            
 ; 
  (setq blcen (list (/ (+ (car mxlst) (cadr mxlst)) 2)
                    (/ (+ (caddr mxlst) (cadddr mxlst)) 2)))
 ; Ŀ
 ;   Centre the scaled block within the box.                               
 ; 
  (command ".move" enam "" blcen cent)
 ; Ŀ
 ;   Calculate whether scaling the x up to the width or the y up to the    
 ;   height would produce the smallest scale factor, use that.             
 ; 
  (setq scalfc (min (/ desx widf) (/ desy hite)))
  (command ".scale" enam "" cent scalfc)
 (princ))
 ; Ŀ
 ;   Blosc end.                                                            
 ; 

 ; Ŀ
 ;   Dirge - get a list of filenames.                                      
 ;   Currently takes no arguments.                                         
 ;   Returns a list: the path, and a list of filenames with paths.         
 ;   Revised: ditches ".dwg" from each file name if required.              
 ; 
 (DEFUN DIRGE (/ pat pref fils num fnam len nulis)
  (if (= "" (setq pat (getstring "Pattern <*.dwg>: ")))
      (setq pat "*.dwg"))
 ; Ŀ
 ;   Ask for a file in the directory to process.                           
 ; 
  (setq pref (getfiled "Indicate a file in the directory you want to print."
                       "" "" 0))
 ; Ŀ
 ;   Remove the filename.                                                  
 ; 
  (setq pref (car (spath pref)))
 ; Ŀ
 ;   Get a list of files.                                                  
 ; 
  (setq fils (vl-directory-files pref pat 1))
  (setq fils (acad_strlsort fils))
  (setq num 0)
  (while (and fils (setq fnam (nth num fils)))
         (setq len (strlen fnam))
         (if (= (strcase (substr fnam (- len 3))) ".DWG")
             (setq fnam (substr fnam 1 (- len 4))))
         (setq num (1+ num))
         (setq fnam (strcat pref fnam))
         (setq nulis (cons fnam nulis)))
 (list prefa (reverse nulis)))
 ; Ŀ
 ;   Dirge end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Insx - put a marker x at a point.                          
 ; 
 (DEFUN INSX (pa ht / ht2)
  (setq ht2 (/ ht 2.0))
  (command "line" (polar pa 0 ht2) (polar pa pi ht2) "")
  (command "line" (polar pa (* pi 0.5) ht2) (polar pa (* pi 1.5) ht2) "")
 (princ))
 ; Ŀ
 ;   Insx end.                                                             
 ; 

 ; Ŀ
 ;   Spath - split a path and filename string into a path and a filename.  
 ; 
 (DEFUN SPATH (tt / pos pp)
 ; Ŀ
 ;   Set the pointer Pos to the end of the string.                         
 ; 
  (setq pos (strlen tt))                            ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq pp (substr tt 1 pos))      ; then set pp to all before
                   (setq tt (substr tt (1+ pos)))   ;          tt to all after
                   (setq pos 1)))                   ;      and pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 (list pp tt))
 ; Ŀ
 ;   Spath end.                                                            
 ; 

 ; Ŀ
 ;   Hoss - the main body.                                                 
 ; 
 (DEFUN C:HOSS (/ blip curnam total flist prefa fillat xins savpa pa cellht
                  cellwd cc cols colsp ht num desx desy namm attlst next len)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setvar "attdia" 0)
  (load "puss")
  (setq curnam (getvar "dwgname"))
  (setq total 0)
 ; Ŀ
 ;   Call Dirge to get the list of files.                                  
 ; 
  (setq flist (dirge))
  (setq prefa (car flist))
  (setq flist (cadr flist))
  (setq total (length flist))
 ; Ŀ
 ;   Flist now contains a list of filenames, and Total their number.       
 ;   See if the user wants to fill in the attributes with their tag        
 ;   names or with an X.                                                   
 ; 
  (initget 0 "Yes No X")
  (setq fillat (getkword "Show attributes Yes/<No>/X: "))
  (if (null fillat) (setq fillat "No"))
 ; Ŀ
 ;   Ask if should mark block insertions.                                  
 ; 
  (initget 0 "Yes No")
  (setq xins (getkword "Mark insertions Y/<N>: "))
  (if (null xins) (setq xins "No"))
  (setq savpa (setq pa (getpoint "Start point <0,0>: ")))
  (if (null pa) (setq savpa (setq pa '(0 0))))
 ; Ŀ
 ;   Get a cell height and width.                                          
 ; 
  (setq cellht (getdist pa "\nCell height <30>: "))
  (if (null cellht) (setq cellht 30))
  (setq cellwd (getdist pa "\nWidth <30>: "))
  (if (null cellwd) (setq cellwd 30))
 ; Ŀ
 ;   Get the row and column layout.                                        
 ; 
  (write-line (strcat "\nNumber of blocks: " (itoa total)))
  (setq cols (fix (sqrt (1+ total))))
  (setq colsp (getint (strcat "Number of columns <" (itoa cols) ">: ")))
  (if colsp (setq cols colsp))
  (setq ht (getdist pa (strcat "\nText size <"
                               (rtos (getvar "textsize") 2 2) ">: ")))
  (if (null ht) (setq ht (getvar "textsize")))
  (setq num 0)
  (setq pa (polar pa pi cellwd))
 ; Ŀ
 ;   Set the desired block height and width variables.                     
 ;   This is currently set at 70% of the cell size.                        
 ; 
  (setq desx (* 0.7 cellwd))
  (setq desy (* 0.7 cellht))
 ; Ŀ
 ;   Go for it.                                                            
 ; 
  (while (setq namm (car flist))
         (setq flist (cdr flist))
         (grtext -2 (itoa total))
         (setq total (1- total))
         (if (< num cols)
             (progn
                  (setq pa (polar pa 0 cellwd))
                  (setq num (1+ num)))
             (progn
                  (setq pa (setq savpa (polar savpa (* pi 1.5) cellht)))
                  (setq num 1)))
         (if (/= curnam namm)                ; don't insert the current drawing
             (progn
                  (if (= xins "Yes") (insx pa ht))  ; mark insertion
 ; Ŀ
 ;   Bring the block definition into the drawing to check for attribute    
 ;   tags, but stop without inserting in an instance of it.                
 ; 
                  (command "insert" namm)
                  (command)
 ; Ŀ
 ;   Call atprmp to get a list of the attribute tags in the block.         
 ; 
                  (setq attlst (atprmp (cadr (spath namm))))
 ; Ŀ
 ;   Insert the block and either fill the attributes or leave them empty.  
 ; 
                  (command "insert" namm pa "" "" "")
                  (cond ((= fillat "Yes")              ; put tag names in atts.
                         (while (setq next (car attlst))
                                (setq attlst (cdr attlst))
                                (command next))
                         (while (= 1 (getvar "cmdactive")) (command " ")))
                        ((= fillat "X")                ; put Xs in atts.
                         (while (= 1 (getvar "cmdactive")) (command "X")))
                        ((= fillat "No")               ; no: leave empty
                         (while (= 1 (getvar "cmdactive")) (command " "))))
 ; Ŀ
 ;   Call Blosc to resize and reposition the block insert.                 
 ; 
                  (blosc pa desx desy (entlast))
 ; Ŀ
 ;   Add the block name text underneath the cell.                          
 ; 
                  (command "text" "c" (polar pa (* pi 1.5) (/ cellht 2.0))
                                                 ht "" (cadr (spath namm))))))
  (setvar "blipmode" blip)
  (command "undo" "end")
 (princ))